/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.player.entity;

import com.typesafe.scalalogging.slf4j.LazyLogging;
import com.typesafe.scalalogging.slf4j.LazyLogging$class;
import com.typesafe.scalalogging.slf4j.Logger;
import rpgboss.model.event.EventHeight$;
import rpgboss.model.event.EventTrigger$;
import rpgboss.player.Finishable;
import rpgboss.player.RpgGame;
import rpgboss.player.entity.Entity;
import rpgboss.player.entity.Entity$;
import rpgboss.player.entity.PlayerEntity;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]3A!\u0001\u0002\u0001\u0013\tia+\u001a5jG2,WI\u001c;jifT!a\u0001\u0003\u0002\r\u0015tG/\u001b;z\u0015\t)a!\u0001\u0004qY\u0006LXM\u001d\u0006\u0002\u000f\u00059!\u000f]4c_N\u001c8\u0001A\n\u0004\u0001)q\u0001CA\u0006\r\u001b\u0005\u0011\u0011BA\u0007\u0003\u0005\u0019)e\u000e^5usB\u0011q\u0002G\u0007\u0002!)\u0011\u0011CE\u0001\u0006g24GG\u001b\u0006\u0003'Q\tAb]2bY\u0006dwnZ4j]\u001eT!!\u0006\f\u0002\u0011QL\b/Z:bM\u0016T\u0011aF\u0001\u0004G>l\u0017BA\r\u0011\u0005-a\u0015M_=M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nq\tAaZ1nKB\u0011QDH\u0007\u0002\t%\u0011q\u0004\u0002\u0002\b%B<w)Y7f\u0011!\t\u0003A!A!\u0002\u0013\u0011\u0013!\u0003<fQ&\u001cG.Z%e!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\rIe\u000e\u001e\u0005\u0006S\u0001!\tAK\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007-bS\u0006\u0005\u0002\f\u0001!)1\u0004\u000ba\u00019!)\u0011\u0005\u000ba\u0001E!)q\u0006\u0001C!a\u00051\u0001.Z5hQR,\u0012A\t\u0005\u0006e\u0001!\t\u0005M\u0001\biJLwmZ3s\u0011\u0015!\u0004\u0001\"\u00116\u0003!\t7\r^5wCR,GC\u0001\u001c=!\r\u0019s'O\u0005\u0003q\u0011\u0012aa\u00149uS>t\u0007CA\u000f;\u0013\tYDA\u0001\u0006GS:L7\u000f[1cY\u0016DQ!P\u001aA\u0002\t\n1#Y2uSZ\fGo\u001c:t\t&\u0014Xm\u0019;j_:DQa\u0010\u0001\u0005B\u0001\u000bq\u0001Z5ta>\u001cX\rF\u0001B!\t\u0019#)\u0003\u0002DI\t!QK\\5u\u0011\u0015)\u0005\u0001\"\u0001G\u0003M\u0001H.Y=fe&sG\u000b[5t-\u0016D\u0017n\u00197f)\u00059\u0005CA\u0012I\u0013\tIEEA\u0004C_>dW-\u00198\t\u000b-\u0003A\u0011\t'\u0002\u0017\r,(O]3oiN#X\r\u001d\u000b\u0002E!)a\n\u0001C!\u001f\u00061Q\u000f\u001d3bi\u0016$2!\u0011)V\u0011\u0015\tV\n1\u0001S\u0003\u0015!W\r\u001c;b!\t\u00193+\u0003\u0002UI\t)a\t\\8bi\")a+\u0014a\u0001\u000f\u0006iQM^3oiN,e.\u00192mK\u0012\u0004")
public class VehicleEntity
extends Entity
implements LazyLogging {
    private final RpgGame game;
    private final int vehicleId;
    private final Logger logger;
    private volatile boolean bitmap$0;

    private Logger logger$lzycompute() {
        VehicleEntity vehicleEntity = this;
        synchronized (vehicleEntity) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public int height() {
        return this.playerInThisVehicle() ? EventHeight$.MODULE$.OVER().id() : EventHeight$.MODULE$.SAME().id();
    }

    @Override
    public int trigger() {
        return EventTrigger$.MODULE$.BUTTON().id();
    }

    @Override
    public Option<Finishable> activate(int activatorsDirection) {
        return new Some<Finishable>(this.game.mapScreen().scriptFactory().runFunction(new StringOps(Predef$.MODULE$.augmentString("game.enterVehicle(%d);")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.vehicleId)}))));
    }

    @Override
    public void dispose() {
    }

    public boolean playerInThisVehicle() {
        return this.playerEntity().inVehicle() && this.playerEntity().inVehicleId() == this.vehicleId;
    }

    @Override
    public int currentStep() {
        return this.playerInThisVehicle() ? this.playerEntity().currentStep() : super.currentStep();
    }

    @Override
    public void update(float delta, boolean eventsEnabled) {
        super.update(delta, eventsEnabled);
        PlayerEntity playerEntity = this.game.mapScreen().playerEntity();
        if (this.playerInThisVehicle()) {
            this.x_$eq(playerEntity.x());
            this.y_$eq(playerEntity.y());
            this.dir_$eq(playerEntity.dir());
        }
    }

    public VehicleEntity(RpgGame game, int vehicleId) {
        this.game = game;
        this.vehicleId = vehicleId;
        super(game.spritesets(), game.mapScreen().mapAndAssetsOption(), game.mapScreen().allEntities(), Entity$.MODULE$.$lessinit$greater$default$4(), Entity$.MODULE$.$lessinit$greater$default$5(), Entity$.MODULE$.$lessinit$greater$default$6(), Entity$.MODULE$.$lessinit$greater$default$7());
        LazyLogging$class.$init$(this);
        this.setSprite(game.project().data().enums().vehicles()[vehicleId].sprite());
    }
}

